import pandas as pd   
from sklearn.model_selection import train_test_split  
import pickle
from decision_company import read_csv_file, remove_labels, divide_dataset, create_LR_instance, classifier_training

# Load the dataset  
credit_customers = read_csv_file("credit_customers.csv")  
  
# Prepare data for logistic regression  
X = remove_labels(credit_customers, 'class')  
y = credit_customers['class'] 
  
# Split data into training and testing sets  
X_train, X_test, y_train, y_test = divide_dataset(X, y, test_size=0.3, random_state=42)  
  
# Fit logistic regression model  
log_reg = create_LR_instance(max_iter=1000)  
log_reg = classifier_training(log_reg, X_train, y_train)   

pickle.dump(X_train,open("./ref_result/X_train.pkl","wb"))
pickle.dump(X_test,open("./ref_result/X_test.pkl","wb"))
pickle.dump(y_train,open("./ref_result/y_train.pkl","wb"))
pickle.dump(y_test,open("./ref_result/y_test.pkl","wb"))
pickle.dump(log_reg,open("./ref_result/log_reg.pkl","wb"))